sampler2D tex;
varying vec2 texCoord;
varying vec4 color;

void main(void) {
    vec4 col = color * texture2D(tex, texCoord);
        
    float luminance = (col.x + col.y + col.z)/3.0;
    col.xyz /= luminance;   

    if (luminance > 0.5) {
        luminance = 1.0;
    } else if (luminance > 0.3) {
        luminance = 0.5;
    } else if (luminance > 0.2) {
        luminance = 0.3;
    } else {
        luminance = 0.1;
    }

    col.xyz *= luminance;

    gl_FragColor = col;
}
